/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: DnsAp_Functionlist.h 75361 2018-04-19 13:50:11Z trieu                 $

   Description:
    ............................................................................

    Includes following functions:

   Changes:

     Version     Date        Author
     X.X.X.X   DD.MM.JJJJ  Mustermann
     Description................................................................
     ---------------------------------------------------------------------------
     1         30.05.2012   TD
     Created
*******************************************************************************/
/*******************************************************************************
 * @file DnsAp_Functionlist.h
 * @brief DnsAp  - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_DnsAp</code>
 * of task.
 ******************************************************************************/
#ifndef __DNSAP__FUNCTIONLIST_H
#define __DNSAP__FUNCTIONLIST_H

#include "TLR_Includes.h"

/******************************************************************************/
/* name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 ******************************************************************************/
TLR_VOID
TaskExit_DnsAp
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_DnsAp
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);

TLR_VOID
TaskEnter_DnsAp
(
 TLR_VOID FAR* pvInit
);

/** @} */


/******************************************************************************/
/* name Task Version
 *
 * Subsequently the version of task is defined.
 ******************************************************************************/
#define DNSAP_STARTUP_PARAM_VERSION2 (2) /* version of task startup parameter */
#define DNSAP_STARTUP_PARAM_VERSION3 (3) /* version of task startup parameter */
#define DNSAP_STARTUP_PARAM_VERSION4 (4) /* version of task startup parameter */
#define DNSAP_STARTUP_PARAM_VERSION  DNSAP_STARTUP_PARAM_VERSION4

/******************************************************************************/
/* name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 ******************************************************************************/
                                                         /* startup parameter */
typedef struct DNSAP_STARTUPPARAMETER_Ttag  DNSAP_STARTUPPARAMETER_T;

/*******************************************************************************
 * task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 ******************************************************************************/
#define DNSAP_STARTUPFLAG_ENABLE_SET_PRODCONS_SIZE_REMOTE             0x00000040
#define DNSAP_STARTUPFLAG_ENABLE_SET_MACID_REMOTE                     0x00000080
#define DNSAP_STARTUPFLAG_ENABLE_SET_BAUDRATE_REMOTE                  0x00000100
#define DNSAP_STARTUPFLAG_ENABLE_DPM_NETWORK_STATE_LEGACY_BEHAVIOR    0x00010000


typedef struct DNS_CIP_DEVICEID_DATA_Ttag
{
  TLR_UINT32 ulEnable;
  TLR_UINT16 usVendorID;
  TLR_UINT16 usDeviceType;
  TLR_UINT16 usProductCode;
  TLR_UINT8  bMajRev;
  TLR_UINT8  bMinRev;
  TLR_UINT8  abProductName[32];
} DNS_CIP_DEVICEID_DATA_T;


struct DNSAP_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;

  TLR_UINT32  ulDPMChannel;           /* Number of the dualport channel dummy */

  TLR_UINT32  ulStartUpFlag;          /* Startup Flag for APP Task            */

  TLR_VOID*   pfncInitSwitch;         /* Function to initialize Switch        */

  TLR_VOID*   pvSwitchCfg;            /* Configuration Parameter for Switch   */

  /****************************************************************************/
  /*                     CIP Device ID: Use for taglist                       */
  /****************************************************************************/
  DNS_CIP_DEVICEID_DATA_T tDeviceId;
};

/******************************************************************************/
#endif /* #ifndef __DNSAP__FUNCTIONLIST_H */
